topic "NetworkProxy";
[2 $$0,0#00000000000000000000000000000000:Default]
[i448;a25;kKO9;2 $$1,0#37138531426314131252341829483380:class]
[l288;2 $$2,2#27521748481378242620020725143825:desc]
[0 $$3,0#96390100711032703541132217272105:end]
[H6;0 $$4,0#05600065144404261032431302351956:begin]
[i448;a25;kKO9;2 $$5,0#37138531426314131252341829483370:item]
[l288;a4;*@5;1 $$6,6#70004532496200323422659154056402:requirement]
[l288;i1121;b17;O9;~~~.1408;2 $$7,0#10431211400427159095818037425705:param]
[i448;b42;O9;2 $$8,8#61672508125594000341940100500538:tparam]
[b42;2 $$9,9#13035079074754324216151401829390:normal]
[{_} 
[ {{10000@(113.42.0) [s0;%% [*@7;4 NetworkProxy]]}}&]
[s1; &]
[s1; [@(0.0.255)3 class][3 _][*3 NetworkProxy]&]
[s2;%% This abstract base class provides a common and simple interface 
for the client side implementation of the widely used network 
proxy protocols such as HTTP and SOCKS variants, and supports 
both [* synchronous ]and [* asynchronous ]operation modes.&]
[s0;i448;a25;kKO9;:noref:@(0.0.255) &]
[ {{10000F(128)G(128)@1 [s0;%% [* Public Method List]]}}&]
[s0; &]
[s5;:NetworkProxy`:`:Attach`(TcpSocket`&`): [_^NetworkProxy^ NetworkProxy][@(0.0.255) `&]_
[* Attach]([_^TcpSocket^ TcpSocket][@(0.0.255) `&]_[*@3 sock])&]
[s2;%% Sets client socket. Returns `*this for method chaining.&]
[s3;%% &]
[s4; &]
[s5;:NetworkProxy`:`:Host`(const String`&`): [_^NetworkProxy^ NetworkProxy][@(0.0.255) `&
]_[* Host]([@(0.0.255) const]_[_^String^ String][@(0.0.255) `&]_[*@3 host])&]
[s2;%% Sets proxy host name. Returns `*this for method chaining.&]
[s3;%% &]
[s4; &]
[s5;:NetworkProxy`:`:Port`(int`): [_^NetworkProxy^ NetworkProxy][@(0.0.255) `&]_[* Port]([@(0.0.255) i
nt]_[*@3 port])&]
[s2;%% Sets proxy port number. Returns `*this for method chaining.&]
[s3;%% &]
[s4; &]
[s5;:NetworkProxy`:`:Timeout`(int`): [_^NetworkProxy^ NetworkProxy][@(0.0.255) `&]_[* Timeo
ut]([@(0.0.255) int]_[*@3 ms])&]
[s2;%% Specifies total allowed time for connection in milliseconds. 
Default timeout value is 120000 miliseconds (two minutes). Returns 
`*this for method chaining.&]
[s3;%% &]
[s4; &]
[s5;:NetworkProxy`:`:SSL`(bool`): [_^NetworkProxy^ NetworkProxy][@(0.0.255) `&]_[* SSL]([@(0.0.255) b
ool]_[*@3 b]_`=_[@(0.0.255) true])&]
[s2;%% Activates or deactivates SSL. Returns `*this for method chaining. 
[* Warning]: This switch will cause NetworkProxy client to start 
an SSL session only with the specified target machine, and not 
with the proxy server itself. Initial connection and subsequent 
authorization requests to the proxy server will be sent over 
an unencrypted channel. &]
[s2;%% &]
[s6;%% Requires Core/SSL package.&]
[s3;%% &]
[s4; &]
[s5;:NetworkProxy`:`:GetSocket`(`)const: [_^TcpSocket^ TcpSocket`&]_[* GetSocket]()_[@(0.0.255) c
onst]&]
[s2;%% Returns a reference to the attached socket.&]
[s3; &]
[s4; &]
[s5;:NetworkProxy`:`:GetType`(`)const: [@(0.0.255) int]_[* GetType]()_[@(0.0.255) const]&]
[s2;%% Returns the proxy type. Three network proxy types are supported: 
HTTP, SOCKS4, SOCKS5&]
[s3; &]
[s4; &]
[s5;:NetworkProxy`:`:Connect`(const String`&`,int`): [@(0.0.255) bool]_[* Connect]([@(0.0.255) c
onst]_[_^String^ String][@(0.0.255) `&]_[*@3 host], [@(0.0.255) int]_[*@3 port])&]
[s2;%% Attempts a proxy connection to a target machine specified 
at [%-*@3 host ][%- and][%-*@3  port][%- .] Returns true on success. 
This method is synchronous. [^topic`:`/`/Core`/src`/TcpSocket`$en`-us`#TcpSocket`:`:WhenWait^ T
cpSocket`::WhenWait()] method will be called periodically, if 
defined.&]
[s3;%% &]
[s4; &]
[s5;:NetworkProxy`:`:StartConnect`(const String`&`,int`): [@(0.0.255) void]_[* StartConne
ct]([@(0.0.255) const]_[_^String^ String][@(0.0.255) `&]_[*@3 host], 
[@(0.0.255) int]_[*@3 port])&]
[s2;%% Starts an asynchronous proxy connection to a target machine 
specified at [%-*@3 host ][%- and] [%-*@3 port]. Must be followed by 
a [^topic`:`/`/NetworkProxy`/src`/NetworkProxy`$en`-us`#NetworkProxy`:`:Do`(`)^ Do(
)] call. .&]
[s3;%% &]
[s4; &]
[s5;:NetworkProxy`:`:Do`(`): [@(0.0.255) virtual] [@(0.0.255) bool]_[* Do]()&]
[s2;%% Implements basic proxy negotiation and connection loop. &]
[s3; &]
[s4; &]
[s5;:NetworkProxy`:`:Abort`(`): [@(0.0.255) void]_[* Abort]()&]
[s2;%% Aborts the negotiation and connection loop.&]
[s3; &]
[s4; &]
[s5;:NetworkProxy`:`:Restart`(`): [@(0.0.255) void]_[* Restart]()&]
[s2;%% Restarts the negotioation and connection loop.&]
[s3; &]
[s4; &]
[s5;:NetworkProxy`:`:InProgress`(`)const: [@(0.0.255) bool]_[* InProgress]()_[@(0.0.255) co
nst]&]
[s2;%% Returns true if proxy connection is in progress.&]
[s3; &]
[s4; &]
[s5;:NetworkProxy`:`:IsSuccess`(`)const: [@(0.0.255) bool]_[* IsSuccess]()_[@(0.0.255) cons
t]&]
[s2;%% Return true if proxy connection is successful.&]
[s3; &]
[s4; &]
[s5;:NetworkProxy`:`:IsFailure`(`)const: [@(0.0.255) bool]_[* IsFailure]()_[@(0.0.255) cons
t]&]
[s2;%% Returns true if proxy connection is failed.&]
[s3; &]
[s4; &]
[s5;:NetworkProxy`:`:GetError`(`)const: [@(0.0.255) int]_[* GetError]()_[@(0.0.255) const]&]
[s2;%% Returns error code. Possible error codes and their descriptions 
are listed [^topic`:`/`/NetworkProxy`/src`/NetworkProxy`$en`-us`#ProxyConnect`(int`,TcpSocket`&`,const String`&`,int`,const String`&`,int`,const String`&`,const String`&`,bool`)^ b
elow].&]
[s3; &]
[s4; &]
[s5;:NetworkProxy`:`:GetErrorDesc`(`)const: [_^String^ String]_[* GetErrorDesc]()_[@(0.0.255) c
onst]&]
[s2;%% Returns the description of last error.&]
[s3;%% &]
[s4; &]
[s5;:NetworkProxy`:`:Trace`(bool`): [@(0.0.255) static] [@(0.0.255) void]_[* Trace]([@(0.0.255) b
ool]_[*@3 verbose]_`=_[@(0.0.255) false])&]
[s2;%% Activates logging of NetworkProxy connections.&]
[s3; &]
[ {{10000F(128)G(128)@1 [s0;%% [* Constructor detail]]}}&]
[s2; &]
[s5;:NetworkProxy`:`:NetworkProxy`(`): [* NetworkProxy]()&]
[s2;%% Default constructor.&]
[s0; &]
[s0; &]
[s3; &]
[ {{10000@(113.42.0) [s0;%% [*@7;4 HttpProxy]]}}&]
[s1;@(0.0.255)3 &]
[s1;:HttpProxy`:`:class: [@(0.0.255)3 class][3 _][*3 HttpProxy][3 _:_][@(0.0.255)3 public][3 _][*@3;3 N
etworkProxy]&]
[s2;%% This class provides an (a)synchronous http proxy client, encapsulating 
the http CONNECT method for http tunneling. &]
[s3; &]
[s4; &]
[s5;:HttpProxy`:`:Auth`(const String`&`,const String`&`): [_^HttpProxy^ HttpProxy][@(0.0.255) `&
]_[* Auth]([@(0.0.255) const]_[_^String^ String][@(0.0.255) `&]_[*@3 user], 
[@(0.0.255) const]_[_^String^ String][@(0.0.255) `&]_[*@3 pass])&]
[s2;%% Sets user and password.&]
[s3;%% &]
[s4; &]
[s5;:HttpProxy`:`:Do`(`): [@(0.0.255) bool]_[* Do]()&]
[s2;%% Progresses the http CONNECT request. Returns true if processing 
is not finished.&]
[s3; &]
[s3; &]
[ {{10000F(128)G(128)@1 [s0;%% [* Constructor detail]]}}&]
[s2; &]
[s5;:HttpProxy`:`:HttpProxy`(`): [* HttpProxy]()&]
[s2;%% Default constructor.&]
[s3; &]
[s4; &]
[s5;:HttpProxy`:`:HttpProxy`(TcpSocket`&`): [* HttpProxy]([_^TcpSocket^ TcpSocket][@(0.0.255) `&
]_[*@3 sock])&]
[s2;%%  Constructs a HttpProxy object with a client socket attached.&]
[s0;%% &]
[s3;%% &]
[ {{10000@(113.42.0) [s0;%% [*@7;4 SocksProxy]]}}&]
[s2;%% &]
[s1;:SocksProxy`:`:class: [@(0.0.255)3 class][3 _][*3 SocksProxy][3 _:_][@(0.0.255)3 public][3 _][*@3;3 N
etworkProxy]&]
[s2;%% This class encapsulates the [^http`:`/`/en`.wikipedia`.org`/wiki`/SOCKS^ SOCKS] 
proxy protocol [^http`:`/`/ftp`.icm`.edu`.pl`/packages`/socks`/socks4`/SOCKS4`.protocol^ v
ersion 4]/4a, and version 5 as defined in [^http`:`/`/www`.rfc`-editor`.org`/rfc`/rfc1928`.txt^ R
FC 1928] and [^http`:`/`/www`.rfc`-editor`.org`/rfc`/rfc1929`.txt^ RFC 
1929]. SocksProxy can work with both IPV4 and IPV6 address families, 
and allows socket binding. UDP association is not supported.&]
[s6;%% Minimum requirements for SOCKS5 IPV6 support on Win32 platform 
are the IPV6 stack and Windows XP SP1&]
[s3; &]
[s4; &]
[s5;:SocksProxy`:`:Auth`(const String`&`): [_^SocksProxy^ SocksProxy][@(0.0.255) `&]_[* Aut
h]([@(0.0.255) const]_[_^String^ String][@(0.0.255) `&]_[*@3 user])&]
[s2;%% Sets user id. Returns `*this for method chaining.&]
[s3;%% &]
[s4; &]
[s5;:SocksProxy`:`:Auth`(const String`&`,const String`&`): [_^SocksProxy^ SocksProxy][@(0.0.255) `&
]_[* Auth]([@(0.0.255) const]_[_^String^ String][@(0.0.255) `&]_[*@3 user], 
[@(0.0.255) const]_[_^String^ String][@(0.0.255) `&]_[*@3 pass])&]
[s2;%% Sets user id and password. Returns `*this for method chaining.&]
[s3;%% &]
[s4; &]
[s5;:SocksProxy`:`:Socks4`(`): [_^SocksProxy^ SocksProxy][@(0.0.255) `&]_[* Socks4]()&]
[s2;%% Sets SOCKS protocol method to version 4/4a. Returns `*this 
for method chaining. This is the default SOCKS connection method.&]
[s3; &]
[s4; &]
[s5;:SocksProxy`:`:Socks5`(`): [_^SocksProxy^ SocksProxy][@(0.0.255) `&]_[* Socks5]()&]
[s2;%% Sets SOCKS protocol method to version 5. Returns `*this for 
method chaining.&]
[s3; &]
[s4; &]
[s5;:SocksProxy`:`:DnsLookup`(bool`): [_^SocksProxy^ SocksProxy][@(0.0.255) `&]_[* DnsLooku
p]([@(0.0.255) bool]_[*@3 b]_`=_[@(0.0.255) true])&]
[s2;%% Enables or disables remote domain name resolving. Returns 
`*this for method chaining. This feature is introduced from SOCKS 
version 4a on, and not supported by every socks server. Disabled 
by default.&]
[s3;%% &]
[s4; &]
[s5;:SocksProxy`:`:Accept`(const String`&`,int`): [@(0.0.255) bool]_[* Accept]([@(0.0.255) c
onst]_[_^String^ String][@(0.0.255) `&]_[*@3 host], [@(0.0.255) int]_[*@3 port])&]
[s2;%% Accepts an incoming connection from.the specified target machine. 
Returns true if successful. This method is blocking (still, [^topic`:`/`/Core`/src`/TcpSocket`$en`-us`#TcpSocket`:`:WhenWait^ T
cpSocket`::WhenWait()] method will be called periodically, if 
defined). This method does not actually put the client socket 
into listening mode. Instead, SocksProxy simply sends a BIND 
request to the proxy server. Bind()ing`-listen()ing`-accep()ting 
process, is then done by the proxy server on behalf of the SocksProxy 
client. After a socket is succesfully obtained (`"bound`"), its 
IP and port number will be sent by the proxy server to the cilent 
and [^topic`:`/`/NetworkProxy`/src`/NetworkProxy`$en`-us`#SocksProxy`:`:WhenBound^ W
henBound] callback will be invoked, if defined. [^topic`:`/`/NetworkProxy`/src`/NetworkProxy`$en`-us`#SocksProxy`:`:GetBoundAddr`(`)^ G
etBoundAddr()] can be used to obtain the IP and Port information 
of the bound socket. &]
[s6;%% An already established connection (a control connection) is 
required. &]
[s3;%% &]
[s4; &]
[s5;:SocksProxy`:`:StartAccept`(const String`&`,int`): [@(0.0.255) void]_[* StartAccept](
[@(0.0.255) const]_[_^String^ String][@(0.0.255) `&]_[*@3 host], [@(0.0.255) int]_[*@3 port])
&]
[s2;%% Starts an asynchronous BIND request. Must be followed by a 
[^topic`:`/`/NetworkProxy`/src`/NetworkProxy`$en`-us`#SocksProxy`:`:Do`(`)^ Do()] 
call.&]
[s6;%% An already established connection (a control connection) is 
required. &]
[s3;%% &]
[s4; &]
[s5;:SocksProxy`:`:Do`(`): [@(0.0.255) bool]_[* Do]()&]
[s2;%% Progresses the SOCKS request. Returns true if processing is 
not finished.&]
[s3; &]
[s4; &]
[s5;:SocksProxy`:`:GetBoundAddr`(`): [_^Tuple2^ Tuple2]<[_^String^ String], 
[@(0.0.255) int]>_[* GetBoundAddr]()&]
[s2;%% Returns the IP address string and port number of the bound 
socket. This method must only be called after a succesful BIND 
request.&]
[s3; &]
[s4; &]
[s5;:SocksProxy`:`:IsBound`(`)const: [@(0.0.255) bool]_[* IsBound]()_[@(0.0.255) const]&]
[s2;%% Returns true if a socket is succesfully bound.&]
[s3; &]
[s4; &]
[s5;:SocksProxy`:`:WhenBound: [_^Callback1^ Callback1]<SocksProxy[@(0.0.255) `&]>_[* WhenBo
und]&]
[s2;%% Called when a socket is bound.&]
[s3; &]
[s4; &]
[s5;:SocksProxy`:`:SocksProxy`(`): [* SocksProxy]()&]
[s2;%% Default constructor.&]
[s3; &]
[s4; &]
[s5;:SocksProxy`:`:SocksProxy`(TcpSocket`&`): [* SocksProxy]([_^TcpSocket^ TcpSocket][@(0.0.255) `&
]_[*@3 sock])&]
[s2;%% &]
[s2;%% Constructs a SocksProxy object with a client socket attached.&]
[s3;%% &]
[s3; &]
[ {{10000@(113.42.0) [s0;%% [*@7;4 NetworkProxy Helper Functions]]}}&]
[s0; &]
[s5;:ProxyConnect`(int`,TcpSocket`&`,const String`&`,int`,const String`&`,int`,const String`&`,const String`&`,int`,bool`): [@(0.0.255) i
nt]_[* ProxyConnect]([@(0.0.255) int]_[*@3 type], [_^TcpSocket^ TcpSocket][@(0.0.255) `&]_[*@3 s
ocket], [@(0.0.255) const]_[_^String^ String][@(0.0.255) `&]_[*@3 proxy`_host], 
[@(0.0.255) int]_[*@3 proxy`_port], [@(0.0.255) const]_[_^String^ String][@(0.0.255) `&]_[*@3 t
arget`_host], [@(0.0.255) int]_[*@3 target`_port], [@(0.0.255) const]_[_^String^ String][@(0.0.255) `&
]_[*@3 user]_`=_Null, [@(0.0.255) const]_[_^String^ String][@(0.0.255) `&]_[*@3 password]_`=
_Null, [@(0.0.255) int]_[*@3 timeout]_`=_[@3 120000], [@(0.0.255) bool]_[*@3 ssl]_`=_[@(0.0.255) f
alse])&]
[s2;%% This convenience function is intended to simplify establishing 
HTTP or SOCKS proxy connections with a specified target machine. 
This function is blocking, yet [^topic`:`/`/Core`/src`/TcpSocket`$en`-us`#TcpSocket`:`:WhenWait^ T
cpSocket`::WhenWait()] method will be called periodically, if 
defined. Returns 0 on success, and `-1 or NetworkProxy specific 
error codes on failure. Below is the available error codes and 
their descriptions.&]
[s3;%% &]
[s4; &]
[s5;:ProxyAccept`(int`,TcpSocket`&`,const String`&`,int`,const String`&`,int`,Callback1`<SocksProxy`&`>`,const String`&`,const String`&`,int`): [@(0.0.255) i
nt]_[* ProxyAccept]([@(0.0.255) int]_[*@3 type], [_^TcpSocket^ TcpSocket][@(0.0.255) `&]_[*@3 s
ocket], [@(0.0.255) const]_[_^String^ String][@(0.0.255) `&]_[*@3 proxy`_host], 
[@(0.0.255) int]_[*@3 proxy`_port], [@(0.0.255) const]_[_^String^ String][@(0.0.255) `&]_[*@3 t
arget`_host], [@(0.0.255) int]_[*@3 target`_port], [_^Callback1^ Callback1]<SocksProxy[@(0.0.255) `&
]>_[*@3 whenbound], [@(0.0.255) const]_[_^String^ String][@(0.0.255) `&]_[*@3 user]_`=_Null
, [@(0.0.255) const]_[_^String^ String][@(0.0.255) `&]_[*@3 password]_`=_Null, 
[@(0.0.255) int]_[*@3 timeout]_`=_[@3 120000])&]
[s2;%% This convenience function is intended to simplify accepting 
connections from a specified target machine, using SOCKS proxy 
protocol`'s BIND method. [%-*@3 whenbound] callback will be called 
when a socket is succesfully bound. [^topic`:`/`/NetworkProxy`/src`/NetworkProxy`$en`-us`#SocksProxy`:`:GetBoundAddr`(`)^ G
etBoundAddr()] can be used to obtain the IP and Port information 
of the bound socket. This function is blocking, yet [^topic`:`/`/Core`/src`/TcpSocket`$en`-us`#TcpSocket`:`:WhenWait^ T
cpSocket`::WhenWait()] method will be called periodically, if 
defined. Returns 0 on success, and `-1 or NetworkProxy specific 
error codes on failure. Below is the available error codes and 
their descriptions. Note that this function is SOCKS protocol 
only.&]
[s6;%% An already established connection (a control connection) is 
required.&]
[s3;%% &]
[s3; &]
[ {{3434:828:5738h16;t/8b/8@3-2 [s0;= [*@7$3;3 NetworkProxy Error Codes and Descriptions]]
::t/15b/15@2-1 [s0; ]
:: [s0; ]
::t/8b/8@(191) [s0;= Error]
:: [s0;=%% Code]
:: [s0;=%% Description]
::t/15b/15@2 [s0; NO`_SOCKET`_ATTACHED]
:: [s0;=%% 10000]
:: [s0;%% No client to serve (No socket attached).]
:: [s0; HOST`_NOT`_SPECIFIED]
:: [s0;=%% 10001]
:: [s0;%% Proxy address or port not specified.]
:: [s0; TARGET`_NOT`_SPECIFIED]
:: [s0;=%% 10002]
:: [s0;%% Target address or port not specified.]
:: [s0; DNS`_FAILED]
:: [s0;=%% 10003]
:: [s0;%% Couldn`'t resolve address.]
:: [s0; CONNECTION`_FAILED]
:: [s0;=%% 10004]
:: [s0;%% Couldn`'t connect to proxy server.]
:: [s0; SSL`_FAILED]
:: [s0;=%% 10005]
:: [s0;%% Couldn`'t start SSL negotioation.]
:: [s0; INVALID`_PACKET]
:: [s0;=%% 10006]
:: [s0;%% Invalid packet received.]
:: [s0; SOCKET`_FAILURE]
:: [s0;=%% 10007]
:: [s0;%% Socket error occured.]
:: [s0; ABORTED]
:: [s0;=%% 10008]
:: [s0;%% Operation was aborted.]
:: [s0; CONNECTION`_TIMED`_OUT]
:: [s0;=%% 10009]
:: [s0;%% Connection timed out.]
:: [s0; HTTP`_CONNECT`_FAILED]
:: [s0;=%% 10010]
:: [s0;%% Http CONNECT method failed.]
:: [s0;%% SOCKS4`_REQUEST`_FAILED]
:: [s0;=%% 091]
:: [s0;%% Request rejected or failed.]
:: [s0;%% SOCKS4`_CLIENT`_NOT`_REACHABLE]
:: [s0;=%% 092]
:: [s0;%% Request failed. Client is not running identd (or not reachable 
from the server).]
:: [s0;%% SOCKS4`_AUTHENTICATION`_FAILED]
:: [s0;=%% 093]
:: [s0;%% Request failed. Cilent`'s identd could not confirm the user 
ID string in the request.]
:: [s0;%% SOCKS4`_ADDRESS`_TYPE`_NOT`_SUPPORTED]
:: [s0;=%% 094]
:: [s0;%% Socks4 protocol doesn`'t support IP version 6 address family. 
Considers using Socks5 protocol instead.]
:: [s0;%% SOCKS5`_GENERAL`_FAILURE]
:: [s0;=%% 001]
:: [s0;%% General failure.]
:: [s0;%% SOCKS5`_CONNECTION`_NOT`_ALLOWED]
:: [s0;=%% 002]
:: [s0;%% Connection not allowed by the ruleset.]
:: [s0;%% SOCKS5`_NETWORK`_UNREACHABLE]
:: [s0;=%% 003]
:: [s0;%% Network unreachable.]
:: [s0;%% SOCKS5`_TARGET`_UNREACHABLE]
:: [s0;=%% 004]
:: [s0;%% Target machine unreachable.]
:: [s0;%% SOCKS5`_CONNECTION`_REFUSED]
:: [s0;=%% 005]
:: [s0;%% Connection refused by the destination host.]
:: [s0;%% SOCKS5`_TTL`_EXPIRED,]
:: [s0;=%% 006]
:: [s0;%% TTL expired.]
:: [s0;%% SOCKS5`_COMMAND`_NOT`_SUPPORTED]
:: [s0;=%% 007]
:: [s0;%% Command not supported / protocol error.]
:: [s0;%% SOCKS5`_ADDRESS`_TYPE`_NOT`_SUPPORTED]
:: [s0;=%% 008]
:: [s0;%% Address type not supported.]
:: [s0;%% SOCKS5`_INVALID`_AUTHENTICATION`_METHOD]
:: [s0;=%% 255]
:: [s0;%% Invalid authentication method. No acceptable methods were 
offered.]
:: [s0;%% SOCKS5`_AUTHENTICATION`_FAILED]
:: [s0;=%% 256]
:: [s0;%% Authentication failed.]}}&]
[s0;%% ]]